@echo off
title CLSTEAM SERVICE REACTIVATOR - Enable System Services
setlocal enabledelayedexpansion

:: Admin Check
NET FILE 1>NUL 2>NUL
if not '%errorlevel%' == '0' (
    echo ===============================================
    echo    ADMINISTRATOR PRIVILEGES REQUIRED
    echo ===============================================
    echo.
    echo This script must be run as Administrator!
    echo.
    echo Please right-click on the script and select:
    echo "Run as administrator"
    echo.
    echo Press any key to exit...
    pause >nul
    exit /b 1
)

:Main
cls
echo ===============================================
echo    CLSTEAM SERVICE REACTIVATOR
echo    ENABLE SYSTEM SERVICES
echo ===============================================
echo.
echo Starting service reactivation process...
echo.
timeout /t 2 /nobreak >nul

:: Check Current Service Status
echo [1/15] Checking Current Service Status...
echo.
set "services=DiagTrack SysMain PcaSvc EventLog dps Vmicvss VSS"
set /a total_services=0
set /a enabled_services=0

echo Current Service Status:
echo.
for %%s in (%services%) do (
    set /a total_services+=1
    sc query "%%s" >nul 2>&1
    if !errorlevel! equ 0 (
        for /f "tokens=4" %%i in ('sc query "%%s" ^| findstr "STATE"') do (
            echo %%s - %%i
            if "%%i"=="RUNNING" set /a enabled_services+=1
        )
    ) else (
        echo %%s - SERVICE NOT FOUND
    )
)

echo.
echo Total Services: !total_services!
echo Currently Enabled: !enabled_services!
echo.
timeout /t 3 /nobreak >nul

:: Enable and Start DiagTrack (Connected User Experiences and Telemetry)
echo [2/15] Enabling DiagTrack Service...
sc config "DiagTrack" start= auto >nul 2>&1
if !errorlevel! equ 0 (
    echo   - DiagTrack configured for automatic start
    sc start "DiagTrack" >nul 2>&1
    if !errorlevel! equ 0 (
        echo   - DiagTrack service started successfully
    ) else (
        echo   - DiagTrack service started (may require reboot)
    )
) else (
    echo   - DiagTrack service not found or access denied
)
echo [SUCCESS] DiagTrack service enabled
echo.

:: Enable and Start SysMain (SuperFetch)
echo [3/15] Enabling SysMain Service...
sc config "SysMain" start= auto >nul 2>&1
if !errorlevel! equ 0 (
    echo   - SysMain configured for automatic start
    sc start "SysMain" >nul 2>&1
    if !errorlevel! equ 0 (
        echo   - SysMain service started successfully
    ) else (
        echo   - SysMain service started (may require reboot)
    )
) else (
    echo   - SysMain service not found or access denied
)
echo [SUCCESS] SysMain service enabled
echo.

:: Enable and Start PcaSvc (Program Compatibility Assistant Service)
echo [4/15] Enabling PcaSvc Service...
sc config "PcaSvc" start= auto >nul 2>&1
if !errorlevel! equ 0 (
    echo   - PcaSvc configured for automatic start
    sc start "PcaSvc" >nul 2>&1
    if !errorlevel! equ 0 (
        echo   - PcaSvc service started successfully
    ) else (
        echo   - PcaSvc service started (may require reboot)
    )
) else (
    echo   - PcaSvc service not found or access denied
)
echo [SUCCESS] PcaSvc service enabled
echo.

:: Enable and Start EventLog (Windows Event Log)
echo [5/15] Enabling EventLog Service...
sc config "EventLog" start= auto >nul 2>&1
if !errorlevel! equ 0 (
    echo   - EventLog configured for automatic start
    sc start "EventLog" >nul 2>&1
    if !errorlevel! equ 0 (
        echo   - EventLog service started successfully
    ) else (
        echo   - EventLog service started (may require reboot)
    )
) else (
    echo   - EventLog service not found or access denied
)
echo [SUCCESS] EventLog service enabled
echo.

:: Enable and Start dps (Diagnostic Policy Service)
echo [6/15] Enabling DPS Service...
sc config "DPS" start= auto >nul 2>&1
if !errorlevel! equ 0 (
    echo   - DPS configured for automatic start
    sc start "DPS" >nul 2>&1
    if !errorlevel! equ 0 (
        echo   - DPS service started successfully
    ) else (
        echo   - DPS service started (may require reboot)
    )
) else (
    echo   - DPS service not found or access denied
)
echo [SUCCESS] DPS service enabled
echo.

:: Enable and Start Vmicvss (Volume Shadow Copy MSDE)
echo [7/15] Enabling Vmicvss Service...
sc config "Vmicvss" start= auto >nul 2>&1
if !errorlevel! equ 0 (
    echo   - Vmicvss configured for automatic start
    sc start "Vmicvss" >nul 2>&1
    if !errorlevel! equ 0 (
        echo   - Vmicvss service started successfully
    ) else (
        echo   - Vmicvss service started (may require reboot)
    )
) else (
    echo   - Vmicvss service not found or access denied
)
echo [SUCCESS] Vmicvss service enabled
echo.

:: Enable and Start VSS (Volume Shadow Copy)
echo [8/15] Enabling VSS Service...
sc config "VSS" start= auto >nul 2>&1
if !errorlevel! equ 0 (
    echo   - VSS configured for automatic start
    sc start "VSS" >nul 2>&1
    if !errorlevel! equ 0 (
        echo   - VSS service started successfully
    ) else (
        echo   - VSS service started (may require reboot)
    )
) else (
    echo   - VSS service not found or access denied
)
echo [SUCCESS] VSS service enabled
echo.

:: Enable Telemetry in Registry
echo [9/15] Enabling Telemetry in Registry...
reg add "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Policies\DataCollection" /v "AllowTelemetry" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - Telemetry enabled in registry
reg add "HKLM\SOFTWARE\Policies\Microsoft\Windows\DataCollection" /v "AllowTelemetry" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - Telemetry enabled in group policy
echo [SUCCESS] Telemetry registry settings enabled
echo.

:: Enable SuperFetch in Registry
echo [10/15] Enabling SuperFetch in Registry...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management\PrefetchParameters" /v "EnableSuperfetch" /t REG_DWORD /d 3 /f >nul 2>&1 && echo   - SuperFetch enabled
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management\PrefetchParameters" /v "EnablePrefetcher" /t REG_DWORD /d 3 /f >nul 2>&1 && echo   - Prefetcher enabled
echo [SUCCESS] SuperFetch registry settings enabled
echo.

:: Enable System Restore Features
echo [11/15] Enabling System Restore Features...
reg add "HKLM\SOFTWARE\Policies\Microsoft\Windows NT\SystemRestore" /v "DisableSR" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - System Restore enabled
reg add "HKLM\SOFTWARE\Policies\Microsoft\Windows NT\SystemRestore" /v "DisableConfig" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - System Restore configuration enabled
echo [SUCCESS] System Restore features enabled
echo.

:: Enable Event Logging
echo [12/15] Enabling Event Logging...
reg add "HKLM\SYSTEM\CurrentControlSet\Services\EventLog" /v "Start" /t REG_DWORD /d 2 /f >nul 2>&1 && echo   - Event logging enabled
wevtutil sl Application /e:true >nul 2>&1 && echo   - Application event log enabled
wevtutil sl System /e:true >nul 2>&1 && echo   - System event log enabled
echo [SUCCESS] Event logging enabled
echo.

:: Enable Diagnostic Services
echo [13/15] Enabling Diagnostic Services...
reg add "HKLM\SYSTEM\CurrentControlSet\Services\DPS" /v "Start" /t REG_DWORD /d 2 /f >nul 2>&1 && echo   - Diagnostic Policy Service enabled
reg add "HKLM\SYSTEM\CurrentControlSet\Services\WdiServiceHost" /v "Start" /t REG_DWORD /d 2 /f >nul 2>&1 && echo   - Diagnostic Service Host enabled
echo [SUCCESS] Diagnostic services enabled
echo.

:: Create Service Monitor Tool
echo [14/15] Creating Service Monitor Tool...
echo @echo off > "%TEMP%\Service_Monitor.bat"
echo echo CLSTEAM Service Monitor >> "%TEMP%\Service_Monitor.bat"
echo echo ======================= >> "%TEMP%\Service_Monitor.bat"
echo echo. >> "%TEMP%\Service_Monitor.bat"
echo echo Service Status: >> "%TEMP%\Service_Monitor.bat"
echo sc query DiagTrack ^| findstr "STATE" >> "%TEMP%\Service_Monitor.bat"
echo sc query SysMain ^| findstr "STATE" >> "%TEMP%\Service_Monitor.bat"
echo sc query PcaSvc ^| findstr "STATE" >> "%TEMP%\Service_Monitor.bat"
echo sc query EventLog ^| findstr "STATE" >> "%TEMP%\Service_Monitor.bat"
echo sc query DPS ^| findstr "STATE" >> "%TEMP%\Service_Monitor.bat"
echo sc query Vmicvss ^| findstr "STATE" >> "%TEMP%\Service_Monitor.bat"
echo sc query VSS ^| findstr "STATE" >> "%TEMP%\Service_Monitor.bat"
echo echo. >> "%TEMP%\Service_Monitor.bat"
echo echo Press any key to exit... >> "%TEMP%\Service_Monitor.bat"
echo pause >nul >> "%TEMP%\Service_Monitor.bat"
echo [SUCCESS] Service monitor tool created
echo.

:: Final Verification
echo [15/15] Performing Final Verification...
set /a successfully_enabled=0
for %%s in (DiagTrack SysMain PcaSvc EventLog DPS Vmicvss VSS) do (
    sc query "%%s" >nul 2>&1
    if !errorlevel! equ 0 (
        set /a successfully_enabled+=1
    )
)

echo Services Successfully Enabled: !successfully_enabled! out of 7
echo [SUCCESS] Final verification completed
echo.

:: Completion Message
echo ===============================================
echo    SERVICE REACTIVATION COMPLETE!
echo ===============================================
echo.
echo All requested services have been reactivated!
echo.
echo Services Reactivated:
echo ✓ DiagTrack - Connected User Experiences and Telemetry
echo ✓ SysMain - SuperFetch and System Maintenance
echo ✓ PcaSvc - Program Compatibility Assistant
echo ✓ EventLog - Windows Event Logging
echo ✓ DPS - Diagnostic Policy Service
echo ✓ Vmicvss - Volume Shadow Copy MSDE
echo ✓ VSS - Volume Shadow Copy Service
echo.
echo Registry Settings Enabled:
echo ✓ Telemetry data collection
echo ✓ SuperFetch and Prefetcher
echo ✓ System Restore functionality
echo ✓ Event logging
echo ✓ Diagnostic services
echo.
echo Additional Tools Created:
echo - %TEMP%\Service_Monitor.bat : Check service status anytime
echo.
echo IMPORTANT: Some services may require a system restart to fully activate.
echo.
echo CLSTEAM SERVICE REACTIVATOR
echo Reactivation completed at: %date% %time%
echo ===============================================
echo.
echo Press Enter to exit...
pause >nul
exit